function [X,Y,Z]=index2circle(data,r,theta,index)

offset = 2*pi*19 / 360;

theta = theta + offset;

N = length(r);
M = length(theta);

Z = zeros(N,M);

for i=1:N
    for j=1:M
        X(i,j) = r(i)*cos(theta(j));
        Y(i,j) = r(i)*sin(theta(j));
        Z(i,j) = data(index(i,j));
    end
    X(i,M+1) = r(i)*cos(theta(1));
    Y(i,M+1) = r(i)*sin(theta(1));
    Z(i,M+1) = data(index(i,j));
end

return